/**
 * This script creates the 'leaguetable' TinyMCE plugin with the related 'selectleaguetable' TinyMCE button, more information
 * are available in the TinyMCE documentation:
 *
 * - https://www.tinymce.com/docs/
 *
 * The modal window is handled with the windowManager API:
 *
 * - https://www.tinymce.com/docs/api/tinymce/tinymce.windowmanager/
 *
 * To have a general idea on how this script works check out the following resources:
 *
 * - https://www.tinymce.com/docs/advanced/creating-a-plugin/
 * - http://jamesdigioia.com/add-button-pop-wordpresss-tinymce-editor/
 */
(function($) {

  'use strict';

  //Creates the 'leaguetable' plugin
  tinymce.PluginManager.add('leaguetable', function(editor, url) {

    'use strict';

    //Creates the 'selectleaguetable' TinyMCE button and associate the 'openleaguetable' command with its click
    editor.addButton('selectleaguetable',
        {title: 'League Table', cmd: 'openleaguetable', icon: 'icon dashicons-list-view',});

    //Create the 'openleaguetable' command
    editor.addCommand('openleaguetable', function() {

      'use strict';

      //Open the modal window
      editor.windowManager.open({

        //Set the various properties of the modal window
        title: 'League Table',
        width: 300,
        height: 72,
        id: 'dalt-leaguetable',

        /**
         * Add buttons in the bottom of the modal window. (eg. Add Table, Add Shortcode, Insert, Cancel, etc.)
         *
         * The buttons should be provided as objects of this array, in this case there is only a single object/button.
         */
        buttons: [
          {
            text: 'Add Table',
            id: 'dalt-button-add-table',
            class: 'dalt-button'
            ,
            onclick: function(e) {

              'use strict';

              let tableId = $('#table-id').val();
              if (tableId === null) {
                tableId = '';
              }

              //Add the shortcode in the post
              editor.execCommand('mceInsertContent', false, '[lt id="' + tableId + '"]');

              //Close the modal window
              editor.windowManager.close();
            },
          }],

      });

      //Generates the content of modal window
      appendContent();

    });

  });

  /**
   * Get the modal window content with an AJAX request and append it in the modal window.
   */
  function appendContent() {

    'use strict';

    //Get a reference to the DOM element
    const contentBody = $('#dalt-leaguetable-body');

    //Prepare the parameters for the AJAX request
    const data = {
      action: 'dalt_get_modal_window_content',
      security: DALT_PARAMETERS.nonce,
    };

    //Send the AJAX request
    $.post(ajaxurl, data, function(responseHtml) {

      'use strict';

      //Append the content in the modal window
      $(contentBody).append(responseHtml);

      //Initialize Chosen
      $('#table-id').chosen();

    });

  }

})(jQuery);